/*
 * Decompiled with CFR 0.152.
 */
package cellframe.datum;

import cellframe.utils.NativeLibraryLoader;
import java.lang.ref.Cleaner;

public class Tx {
    private static final Cleaner cleaner = Cleaner.create();
    private final long nativeHandle;
    private boolean isClosed;
    private final Cleaner.Cleanable cleanable;

    Tx(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new IllegalArgumentException("Invalid native handle");
        }
        this.nativeHandle = nativeHandle;
        this.isClosed = false;
        this.cleanable = cleaner.register(this, new NativeResourceCleaner(nativeHandle));
    }

    public static Tx fromNativeHandle(long nativeHandle) {
        return new Tx(nativeHandle);
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    private static native void close(long var0);

    private static native String toJSON(long var0, String[] var2);

    private static native long fromJSON(String var0, String[] var1);

    public String toJson() {
        String[] outerr = new String[1];
        String res = Tx.toJSON(this.nativeHandle, outerr);
        if (res == null) {
            throw new RuntimeException(outerr[0]);
        }
        return res;
    }

    public static Tx fromJson(String json) {
        String[] outerr = new String[1];
        long res = Tx.fromJSON(json, outerr);
        if (res == 0L) {
            throw new RuntimeException(outerr[0]);
        }
        return new Tx(res);
    }

    static {
        NativeLibraryLoader.loadNativeLibraries();
    }

    private static class NativeResourceCleaner
    implements Runnable {
        private final long nativeHandle;

        NativeResourceCleaner(long nativeHandle) {
            this.nativeHandle = nativeHandle;
        }

        @Override
        public void run() {
            if (this.nativeHandle != 0L) {
                Tx.close(this.nativeHandle);
            }
        }
    }
}

