# Cellframe Node Diagnostic Tool

A cross-platform diagnostic and monitoring tool for Cellframe Node that collects system information, monitors node processes, and sends telemetry data.

## 📖 Documentation

- 📋 **Linux Installation Guide**: [INSTALL-LINUX.md](INSTALL-LINUX.md)
- 🔧 **CI/CD Pipeline**: [docs/CI-CD.md](docs/CI-CD.md)

## Features

- **System Monitoring**: CPU, memory, disk usage, and network interfaces
- **Node Monitoring**: Cellframe Node process status and resource usage  
- **CLI Integration**: Network information, blocks, transactions via Cellframe CLI
- **Telemetry**: Automatic data collection and transmission to monitoring servers
- **Cross-Platform**: Linux, macOS, and Windows support
- **Service Integration**: Systemd, launchd, and Windows Service support

## Requirements

### Build Dependencies
- **CMake** 3.16 or later
- **Qt5** 5.15 or later (Core, Network modules)
- **C++17** compatible compiler
- **Platform-specific**:
  - Linux: GCC 7+ or Clang 6+
  - macOS: Xcode 10+ or Command Line Tools
  - Windows: Visual Studio 2019+ or Build Tools

### Runtime Dependencies
- **Cellframe Node** (recommended for full functionality)
- **Qt5 Runtime Libraries**

## Quick Start

### Linux (DEB Package)

```bash
# Download and install the latest DEB package
wget https://internal-pub.cellframe.net/linux/cellframe-node-diagtool/feature-17573/cellframe-diagtool-1.0.2-linux.deb
sudo dpkg -i cellframe-diagtool-1.0.2-linux.deb

# Start as service
sudo systemctl start cellframe-diagtool
sudo systemctl enable cellframe-diagtool
```

### Building from Source

```bash
# Clone the repository
git clone https://gitlab.demlabs.net/cellframe/cellframe-node-diagtool.git
cd cellframe-node-diagtool

# Create build directory
mkdir build && cd build

# Configure and build
cmake .. -DCMAKE_BUILD_TYPE=Release -DENABLE_PACKAGING=ON
cmake --build . --parallel $(nproc)

# Create packages
cpack
```

## Advanced Building

### Manual CMake Build

```bash
# Create build directory
mkdir build && cd build

# Configure
cmake .. \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_INSTALL_PREFIX=/usr/local \
    -DENABLE_PACKAGING=ON

# Build
cmake --build . --parallel $(nproc)

# Install
sudo cmake --install .

# Create packages
cpack
```

### Build Options

```bash
# Available CMake options:
# -DCMAKE_BUILD_TYPE=Release|Debug
# -DENABLE_PACKAGING=ON|OFF
# -DCMAKE_INSTALL_PREFIX=/path/to/install
# -DINSTALL_WITH_NODE=ON|OFF
```

## Installation

### Package Installation

#### Debian/Ubuntu
```bash
sudo dpkg -i cellframe-diagtool-*.deb
sudo systemctl start cellframe-diagtool
```

#### CentOS/RHEL/Fedora
```bash
sudo rpm -i cellframe-diagtool-*.rpm
sudo systemctl start cellframe-diagtool
```

#### macOS
```bash
sudo installer -pkg cellframe-diagtool-*.pkg -target /
sudo launchctl load /Library/LaunchDaemons/com.demlabs.cellframe-diagtool.plist
```

#### Windows
Run the installer executable as Administrator, or:
```cmd
msiexec /i cellframe-diagtool-*.msi /quiet
```

### Manual Installation

1. Copy the executable to desired location
2. Copy configuration files
3. Set up service (optional)

## Configuration

The main configuration file is located at:
- **Linux**: `/etc/cellframe-diagtool/diagdata.json`
- **macOS**: `/Library/Application Support/CellframeNode/etc/diagdata.json`
- **Windows**: `%PROGRAMDATA%\Cellframe Diagtool\config\diagdata.json`

### Configuration Options

```json
{
    "enabled": "true",
    "send_data_delay": "30000",
    "telemetry_urls": [
        "https://telemetry.cellframe.net/diag_report"
    ],
    "allowed_data": {
        "cli_data": true,
        "system": true,
        "process": true,
        "roles": true
    },
    "network": {
        "tcp_server_port": 8040,
        "tcp_server_enabled": true
    },
    "logging": {
        "level": "info",
        "console_enabled": true
    }
}
```

## Service Management

### Linux (systemd)
```bash
# Start/stop service
sudo systemctl start cellframe-diagtool
sudo systemctl stop cellframe-diagtool

# Enable/disable autostart
sudo systemctl enable cellframe-diagtool
sudo systemctl disable cellframe-diagtool

# Check status and logs
sudo systemctl status cellframe-diagtool
sudo journalctl -u cellframe-diagtool -f
```

### macOS (launchd)
```bash
# Load/unload service
sudo launchctl load /Library/LaunchDaemons/com.demlabs.cellframe-diagtool.plist
sudo launchctl unload /Library/LaunchDaemons/com.demlabs.cellframe-diagtool.plist

# Check status
sudo launchctl list | grep cellframe-diagtool
```

### Windows (Service)
```cmd
REM Start/stop service
net start CellframeDiagtool
net stop CellframeDiagtool

REM Or use Services.msc GUI
services.msc
```

## API

The diagnostic tool provides a TCP API on port 8040 (configurable) for external clients:

### Get Diagnostic Data
Connect to `localhost:8040` and the tool will send JSON diagnostic data.

### Control Data Transmission
Send JSON command to control telemetry:
```json
{
    "send_data_flag": false
}
```

## Troubleshooting

### Common Issues

1. **Service fails to start**
   - Check if Cellframe Node is installed
   - Verify configuration file syntax
   - Check file permissions

2. **No data collected**
   - Ensure Cellframe Node CLI is accessible
   - Check network connectivity
   - Verify configuration settings

3. **Build failures**
   - Install required Qt5 development packages
   - Update CMake to required version
   - Check compiler compatibility

### Log Locations
- **Linux**: `journalctl -u cellframe-diagtool`
- **macOS**: `/var/log/cellframe-diagtool.log`
- **Windows**: Windows Event Log (Application)

## Development

### Project Structure
```
cellframe-node-diagtool/
├── CMakeLists.txt              # Main build configuration
├── main.cpp                    # Application entry point
├── version.mk                  # Version information
├── CellframeNodeDiagtool/      # Core implementation
│   ├── DiagnosticWorker.*      # Main diagnostic controller
│   ├── AbstractDiagnostic.*    # Base diagnostic class
│   ├── LinuxDiagnostic.*       # Linux-specific implementation
│   ├── MacDiagnostic.*         # macOS-specific implementation
│   ├── WinDiagnostic.*         # Windows-specific implementation
│   ├── DiagDataManager.*       # Configuration management
│   ├── DiagDataSendingWorker.* # Network communication
│   └── NotifyWorker.*          # Node communication
├── cmake/                      # CMake modules and packaging
├── packaging/                  # Platform-specific packaging files
├── config/                     # Configuration templates
├── scripts/                    # Version and pipeline scripts
├── docs/                       # Documentation
└── .gitlab-ci.yml             # CI/CD pipeline configuration
```

### Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test on all supported platforms
5. Submit a pull request

## License

This project is licensed under the GPL-3.0 License - see the [LICENSE](LICENSE) file for details.

## Support

- **Documentation**: https://cellframe.net/docs
- **Issues**: Create an issue in this repository
- **Contact**: support@demlabs.net

## CI/CD Pipeline

The project includes a comprehensive GitLab CI/CD pipeline that automatically builds packages for all supported platforms.

### Pipeline Stages
1. **Build**: Compiles for Linux, macOS, and Windows
2. **Test**: Runs integration tests and validation
3. **Package**: Creates distribution packages (DEB, RPM, PKG, MSI)
4. **Deploy**: Deploys to development/production environments

### Supported Platforms
- **Linux AMD64**: DEB and RPM packages
- **macOS AMD64**: PKG installer (cross-compiled)
- **Windows AMD64**: MSI and NSIS installers

### Docker Images
- `demlabs/debian/amd64:qt5` - Linux build environment
- `demlabs/macos/amd64:qt5` - macOS cross-compilation
- `demlabs/windows/amd64:qt5` - Windows build environment

### Artifacts and Downloads

The latest packages are available from the CI/CD pipeline:
- **Linux DEB**: `cellframe-diagtool-1.0.2-linux.deb`
- **Linux TAR.GZ**: `cellframe-diagtool-1.0.2-linux.tar.gz`
- **Windows MSI**: `cellframe-diagtool-1.0.2-windows.msi`
- **macOS PKG**: `cellframe-diagtool-1.0.2-macos.pkg`

For detailed CI/CD documentation, see [docs/CI-CD.md](docs/CI-CD.md).

## Changelog

### Version 1.0.2 (Current)
- Optimized binary size with automatic stripping
- Improved systemd service integration
- Enhanced CI/CD pipeline with multi-platform support
- Cleaned up repository structure
- Updated documentation and installation guides

### Version 1.0.1
- Fixed service installation paths
- Improved error handling
- Enhanced telemetry functionality

### Version 1.0.0
- Initial release
- Cross-platform support (Linux, macOS, Windows)
- System and node monitoring
- Telemetry transmission
- Service integration
- Package distribution
- Automated CI/CD pipeline
